/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.remotesupport.credentials;

import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hwmca.base.rsf.sas.CredentialStore;
import com.ibm.hwmca.base.rsf.sas.CredentialStoreAccessException;
import com.ibm.hwmca.base.rsf.sas.UnsupportedTargetException;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;

public class RsfCredentialStore
implements CredentialStore {
    private static final String TRACE_MASKT = "XRSFPI T";
    private static final String TRACE_MASKF = "XRSFPI F";
    private static final String TRACE_MASKD = "XRSFPI D";
    private static CredentialStore store = new RsfCredentialStore();
    private String hostName;

    private RsfCredentialStore() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.hostName = "127.0.0.1";
        }
    }

    public static CredentialStore getCredentialStore() {
        return store;
    }

    public SysInfo getCredential(Object object) throws UnsupportedTargetException, CredentialStoreAccessException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> RsfCredentialStore::getCredential() for " + object));
        String[] stringArray = new String[2];
        try {
            PIHSCCECCIMClient pIHSCCECCIMClient = PIHSCCECCIMClient.createInstance(this.hostName, (String)object, true, "root/ibmhscS1_0");
            stringArray = pIHSCCECCIMClient.getSystemCredential();
        }
        catch (Exception exception) {
            throw new CredentialStoreAccessException((Throwable)exception);
        }
        if (stringArray == null) {
            Trace.trace((String)TRACE_MASKT, (Object)"<- RsfCredentialStore::getCredential() return null");
            return null;
        }
        if (stringArray.length < 2) {
            Trace.trace((String)TRACE_MASKT, (Object)("<- RsfCredentialStore::getCredential() return null because return String[] length=" + stringArray.length));
            return null;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-RsfCredentialStore::getCredential() return credential");
        return new SysInfo(stringArray[0], stringArray[1]);
    }

    public void storeCredential(Object object, SysInfo sysInfo) throws UnsupportedTargetException, CredentialStoreAccessException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> RsfCredentialStore::storeCredential() for " + object));
        try {
            PIHSCCECCIMClient pIHSCCECCIMClient = PIHSCCECCIMClient.createInstance(this.hostName, (String)object, true, "root/ibmhscS1_0");
            pIHSCCECCIMClient.saveSystemCredential(sysInfo.getMachineId(), sysInfo.getPassword());
        }
        catch (Exception exception) {
            throw new CredentialStoreAccessException((Throwable)exception);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- RsfCredentialStore::storeCredential()");
    }
}

